class SlideOrderCache
{
    private static SlideOrderCacheNode first;
    private static int count=0;
    
    public static synchronized void cache(int slideId, int[] preds, int[] succs)
    {
        if(0==count)
        {
            first=new SlideOrderCacheNode(slideId, preds, succs);
            count++;
        }
        else
        cache(slideId,preds,succs,first);
    }
    
    private static void cache(int slideId, int[] preds, int[] succs, SlideOrderCacheNode pointer)
    {
        if(pointer.slideId==slideId)pointer.init(slideId,preds,succs);
        else
        if(pointer.slideId>slideId)
            if(pointer.right==null)
            {
                pointer.right=new SlideOrderCacheNode(slideId,preds,succs);
                count++;
            }
            else cache(slideId,preds,succs,pointer.right);
        else
            if(null==pointer.left)
            {
                pointer.left=new SlideOrderCacheNode(slideId,preds,succs);
                count++;
            }
            else cache(slideId,preds,succs,pointer.left);
    }
}


class SlideOrderCacheNode
{
    SlideOrderCacheNode left;
    SlideOrderCacheNode right;
    int slideId;
    int[] predSlides;
    int[] succSlides; //Obs! redundancy
    
    SlideOrderCacheNode(int i, int[] j, int[] k)
    {
        init(i,j,k);
    }
    
    void init(int i, int[] j, int[] k)
    {
        slideId=i;
        predSlides=j;
        succSlides=k;
    }
}
